#ifdef NEVER_COMPILE
/*! End * Kopf nicht lesen
  Liste der Scriptbefehle fr toolscript.
  Kopien aus den Objektfefinitionen.
*/

/*! Begin class tTurtle Javascript ************************************/
/*! |t.Turtle|*********************************************************/
  //Basisbefehle fr die Turtle

/*! |Einstellungen|****************************************************/
     //Einstellungen sind nur in init() wirksam.
     //Alle setPage() Befehle setzen Pen und Brush.

 void setPage(qreal x0, qreal y0, int dinA=255);
     //Papierformat und Koordinatenursprung einstellen.
     //Linken obere Ecke: (x0,y0) in mm.
     //dinA: 0-9 Querformat. 10-19 Hochformat. 255 Setup.

void setPage(int din=255);
     //Koordinatenursprung in Blattmitte
     //dinA: 0-9 Querformat. 10-19 Hochformat. 255 Setup.

void setMargin(qreal RandX=-1, qreal RandY=-1);
     //RandX=-1 oder RandY=-1: Rand aus Setup.
     //RandX=-2 oder RandY=-2: Zeichenrechteck quadratisch.

void setAutoPaint(bool on=true);
     //Automatisches Neuzeichnen abschalten.
     //true:  Grafik immer automatisch neu zeichen.
     //false: Grafik erst nach Mausklick neu zeichnen.

void setAntiAliasing(bool on=true) ;
     //Antialaising. On: feinere Linien, langsamer.

/*! |Pen und Brush|****************************************************/
     //Zeichenstift und Malfarbe

void setNoStyle();
     //Turtle zeichnet unsichtbar.
     //Aktuellen Pen und Brush merken.
     //Pen=0 und Brush=0 setzen.

void setPen(const QString &Farbe="", qreal Breite=-1, int Style=-1);
     //Farbe siehe Hilfe Farben oder Tool: Farbmischung.
     //Breite: in mm, 0 fr ein Pixel.
     //Style: 0-6, siehe Tool: Penstyle.
     //Defaults: Letzten Stift verwenden.

void setPenWidth(qreal Breite, int CapStyle=-1);
     //Breite -1: nur CapStyle setzen.
     //CapStyle: Linenenden Flat=0, Square=16 oder Rounded=32 setzen.

void setBrush(const QString &Farbe="", int Style=-1, int alpha=-1);
     //Farbe siehe Hilfe Farben oder Tool: Farbmischung.
     //Style 0-24, siehe Tools: Brushstyle.
     //Transparenz 0-255.
     //Defaults: Letzten Brush verwenden.

void setGradient(qreal x1, qreal y1, qreal x2, qreal y2, const QString &Rgb1, const QString &Rgb2);
     //Linearen Farbverlauf von Farbe1 in P1(x1,y1) nach Farbe2 in P2(x2,y2) festlegen.
     //Verwendung nur mit setBrush("",15);

void setGradient(qreal t, const QString &Rgb);
     //0<t<1: Farbe im Zwischenpunkt P1 + t*(P2-P1) festlegen.
     //Verwendung mit setBrush("",15).


/*! |Drehen|***********************************************************/
     //Winkel in Grad. Uhrzeigersinn ist negativ.

void turn(qreal w);
     //Richtung der Turtle realtiv ndern.
void turnTo(qreal w);
     //Richtung absolut einstellen, x-Achse hat 0.
void turnTo(qreal x, qreal y);
     //Richtung (lastX(),lastY()) nach P(x,y)
void turnTo(const QString Name);
     //Richtung (lastX(),lastY()) nach Punkt "Name"

/*! |Bewegen|**********************************************************/
    //Bewegungen mit aktuellem Pen. Einheit mm.

void move(qreal mm);
     //Turtle um mm in aktueller Richtung bewegen.
void moveTo(qreal x, qreal y);
     //Turtle auf Punkt (x,y) bewegen
void moveTo(const QString Name);
     //Turtle auf Punkt "Name" bewegen

void goTo(qreal x, qreal y);
     //Turtle ohne Pen auf (x,y)
void goTo(const QString Name, int Index=0);
     //Turtle ohne Pen auf Punkt "Name"[Index].
     //Index= 0: erster Polygonpunkt, usw.
     //Index=-1: letzter Polygonpunkt.
     //Index=-2: vorletzter Polygonpunkt, usw.

/*! |Polygon|**********************************************************/
//Die Turtle besitzt ein Polygon. Das Turtle-Polygon wird
//mit beginPolygon() und endPolygon(...) erzeugt.

void beginPolygon();
     //Polygon lschen, Polygonmodus einschalten. Die Endpunkte
     //jeder Turtlebewegung werden ans Polygon angehngt.

void endPolygon(int FillMode=0);
     //Polygonmodus beenden.
     //FillMode 0: Polygon schliessen, Qt::OddEvenFill.
     //FillMode 1: Polygon schliessen, Qt::WindingFill.
     //FillMode 2: Polygon schliessen, nicht fllen.
     //FillMode 3: Polygon nicht schliessen, nicht fllen.

void drawPolygon();
      //Polygon auf Turtlepos mit -richtung zeichnen.

void movePolygon(qreal x, qreal y);
     //Polygonpunkte verschieben.
     //Punkt Polygon[0] auf Punkt (x,y).

void rectPolygon(qreal dx, qreal dy, int FillMode=0);
      //Rechteckiges Polygon auf Turtlepos mit -richtung.

void trianglePolygon(qreal c, qreal w_ca, qreal a,  int FillMode=0);
     //Dreieck ABC mit A(lastX(),lastY())
     //c in Richtung lastW();
     //w_ca ist Winklel ca

void isoPolygon(qreal r, int n=-1, int FillMode=0);
     //Polygon mit n-Ecken, Radius r, Mittelpunkt Last(), Richtung lastW()
     //n=-1: Kreisnherung, n=-2 hhere Auflsung fr Kreis

void splinePolygon(qreal dt=0.1);
     //Polygon durch ein Spline-Polygon ersetzen.

void cPolygon();
     //Polygon durch C-Polygon ersetzen.
     //Polygon am Endpunkt spiegeln

void clrPolygon();
     //Polygon lschen und Polygonmodus beenden


/*! |Text|*************************************************************/
void text(const QString &s);
     //Text an Turtlepos in -richtung anzeigen.
void text(qreal x, qreal y, const QString &s);
     //Text an P(x,y) in -richtung anzeigen.
void text(qreal x, qreal y, qreal x1, qreal y1, const QString &s);
     //Text in Rechteck P(x,y) und Q(x1,y1) schreiben.

void setFont(const QString &Font, qreal Size, bool Fix=true, int Weight=50);
     //Font: "Times","Courrier","Arial" usw.
     //Size: in mm
     //Fix: Proportional
     //Weight: 0-99, Normal=50, Bold=75

void setWeight(int Weight);
     //Weight: 0-99, Normal=50, Bold=75

/*! |Rechtecke|********************************************************/
void rahmen();
     //Blattrahmen neu zeichnen.
void rectangle(qreal dx, qreal dy);
     //Rechteck (dx,dy) in Turtlerichtung zeichnen.


/*! |Punkt|************************************************************/
void drawPoint(qreal x, qreal y);
     //Punktmarke zu Punkt(x,y) zeichnen.


/*! |Bilder|***********************************************************/

qreal bild(const QString &DateiName, qreal w_mm=-1, qreal h_mm=-1);
      //Bild an Turtleposition in -richtung zeichnen.
      //Breite w_mm, Hoehe h_mm. Ist ein Wert -1: proportional.
      //Rueckgabe: 0 oder die fehlende Breite oder Hhe

/*! |Abfragen|*********************************************************/
    //Die aktuellen Einstellungen der Turtle abfragen.
qreal  lastX();
       //Letzte x-Koordinate
qreal  lastY();
       //Letzte y-Koordinate

qreal  lastW();
       //Letzte Richtung in 

qreal  getW();
       //Richtung des Vektors (0,0)->(lastX(),lastY())
double getL();
       //Betrag des Vektors (0,0)->(lastX(), lastY())

void   msgTurtle();
       //Einstellungen der Turtle in der MsgBox ausgeben

qreal  P0x();
       //Plotrechteck: x,links,oben
qreal  P0y();
       //Plotrechteck: y,links,oben
qreal  P1x();
       //Plotrechteck: x,rechts,unten
qreal  P1y();
       //Plotrechteck: y,rechts,unten

/*! End Javascript **************************************************/


/*! Begin class tGrafik Javascript  **********************************/
/*! |t.Grafik|********************************************************/
    //Erweiterte Turtlebefehle

/*! |Koordinatensystem|***********************************************/
    //Koordinatensystem zeichnen

void drawKoordSystem(bool Beschriftung=true, qreal Einheit=10, qreal PSize=0.6);
     //Beschriftung true/false.
     //Einheit: Abstand der Marken in mm.
     //PSize: Grsse in mm.

void drawRaster(qreal Einheiten_mm=10, qreal PSize=0.6);
     //Rastermarken zeichnen.
     //Einheit: Abstand in mm.
     //PSize: Grsse in mm.

/*! |Meldungen|*******************************************************/
    //Textausgaben im Meldungsfenster

void msg(QVariant s=" ", const QString rgb="black");
     //Meldung s im Meldungsfenster ausgeben
void clrMsg();
     //Meldungsfenster lschen

void msgScript(bool showWerte=true);
     //Javascript-Objekte des Scripts in der Msgbox ausgeben.
     //true : Objektnamen und Werte.
     //false: Nur Objektnamen.

QString infoScript(bool showWerte=true);
        //String fr msgScript()


/*! |Farben und Zufall|***********************************************/

qreal   rnd(qreal max);
        //Zufallszahlen aus [0,max]
qreal   rndW(qreal min, qreal max);
        //Zufallszahlen [min,max] und [-min,-max]

void    setRndRGB(const QString &RGB1="", const QString &RGB2="black");
        //Anfangsfarben fr rndRGB(), rndRGB1() und rndRGB2()
void    setRndHeller(int Heller=100, int rndHeller=0);
        //Aufhellung l fr rndRGB(), rndRGB1() und rndRGB2().
        //l=Heller + rnd(rndHeller).
        //0<l bis l<100: Ergebnis dunkler.
        //100<l bis l<400: Ergebnis heller.

QString rndRGB(qreal rnd);
        //Farbe zwischen RGB1 und RGB2. 0<=rnd<=1.

QString rndRGB1();
        //Zufallsfarbe zu RGB1
QString rndRGB2();
        //Zufallsfarbe zwischen RGB1 und RGB2

QString rgbName(int rot, int gruen, int blau);
        //Rckgabe RGB-String


/*! |Diashow|*********************************************************/

qreal showDia(qreal ms, qreal Startwert, qreal Decrement=1);
      //Grafik alle ms neu zeichnen.
      //Startwert mit Decrement herunterzhlen.
      //Rckgabe: DiaRestwert in ms.
      //
      //if (DiaRestwert<=0)	DiaRestwert = Startwert - Decrement;
      //else	DiaRestwert = DiaRestwert - Decrement;

      //if (DiaRestwert>0) 	Neuzeichnen in ms.
      //else	Stop

/*! |t.Befehle|*******************************************************/
    //Eigene Befehle fr Funktionen und Polygonobjekte.

/*! |Befehle: Funktionen|*********************************************/
    //Funktionen werden in der Form
    //function 'Name'() { Befehl; Befehl; ... }
    //gespeichert.

void defCall(const QString Name, const QString Befehle, int mode=0);
     //Funktionsdefinition 'Name' anlegen oder erweitern.
     //mode=0: Funktion "Name" neu anlegen und Befehle anhngen.
     //mode=1: Befehle an Funktion "Name" anhngen.

void recDraw(QString Name="");
     //Befehlsrecorder. Turtlebefehle als Funktion aufzeichnen.
     //Name<>"": Funktion 'Name' anlegen und Aufzeichnugsmodus ein.
     //Alle folgenden Turtlebefehle werden aufgezeichnet.
     //Name=="": Aufzeichnung beenden.

void call(const QString Name);
     //Funktion ausfhren

/*! |Befehle: Polygone definieren|************************************/
    //Mit def-Aufrufen werden verschachtelte
    //Polygonobjekte definiert.

void defPoint(const QString Name);
     //Punkt (lastY(),lastY()) als Punkt "Name" speichern

void defPoint(const QString Name, int Index);
     //Punkt aus Turtlepolygon kopieren.
     //Polygon[Index] unter "Name" speichern.
     //Index=-1 letzter Punkt.

void defPoint(const QString Name, const QString P1, const QString P2, qreal t);
     //Teilungspunkt P = P1 + t*(P2-P1) als Punkt "Name" speichern

void defVector(const QString Name, const QString P1, const QString P2, qreal t=1);
     //Ortsvektor t*(P2-P1) als Punkt "Name" speichern

void defLine(const QString Name,  qreal l);
     //P1 (lastY(),lastY()) und P2 move(l) mit LastW()
     //P1 und P2 als Befehls-Polygon "Name" speichern

void defLine(const QString Name, const QString P1, const QString P2);
     //Punkte P1 und P1 als Befehls-Polygon "Name" speichern

void defDraw(const QString Name, int mode=0);
     //Speichert unter 'Name' Listen von Polygonobjekten.
     //Ein Polygonobjekt bernimmt von der Turtle die
     //Daten: Polygon, Pen, Brush, FillMode.
     //
     //mode=0: 'Name' neu anlegen und Turtledaten speichern.
     //mode=1: Turtledaten an Befehl 'Name' anhngen.
     //mode=2: Polygon zuerst am ersten Polygonobjekt
     //klippen und  Turtledaten anhngen.
     //mode=3: Einpassen:
     //Das erste Polygon [N0, .. Nm] von 'Name'
     //durch das Turtlepolygon [P0, .. Pn] ersetzen.
     //N0!=Nm: Turtlepolygon in Polygon 'Name'
     // einpassen. P0 -> N0 und Pn -> Nm
     //N0==Nm: Turtlepolygon verschieben mit P0 -> N0


bool defScript(const QString Flag, const QString Grafikname);
     //Befehle eines anderen Scripts in die
     //Befehlsliste eintragen und ein Funktions-Flag setzen.
     //
     //Funktion Flag() ist in Befehlsliste:
     //  * nichts tun
     //  * Rckgabe true
     //Flag ist nicht in Befehlsliste:
     //  * Script 'Grafikname' ausfhren
     //  * Funktion Flag() eintragen
     //  * Aktuelles Script neu starten
     //  * Rckgabe false

/*! |Befehle: Polygone zeichnen|**************************************/
    //Alle Polygonobjekte werden an der aktuellen Turtleposition,
    //mit der aktuellen Turtlerichtung und unter
    //Verwendung der Abbildung 'drawMatrix' ausgefhrt.

void draw(const QString Name, bool UseStyle=true);
     //'Name' ist Polygonobjekte:
     //    Befehl an der aktuellen Turtleposition
     //    und mit Turtlerichtung und unter
     //    Verwendung der drawMatrix ausfhren.
     //'Name' ist Funktion: Funktion ausfhren.
     //UseStyle==true : Definierten Style verwenden
     //UseStyle==false: Aktuellen Turtle-Style verwenden

void drawName(const QString Name, qreal dx=0, qreal dy=0);
     //Beschriftung 'Name' an Objektposition anzeigen.
     //Position um (dy,dy) veschieben.

void shift(const QString Vektor,  qreal t=1);
     //Ein moveTo auf: (lastX(),lastY()) + t*("Vektor"))
     //Drehung: um lastW();


/*! |Befehle: Abbildungen|********************************************/
    //Befehle zum Erzeugen der Abbildungsmatrix 'drawMatrix'
    //Achtung: Die Einstellungen verndern die bestehende
    //Matrix kumulativ und sind nicht kommutativ!
    //reset=true : Abbildung auf die Einheitsmatrix anwenden.
    //reset=false : Abbildung auf drawMatrix anwenden.

void setRotate(qreal Winkel, bool reset=true);
     //Drehung um Punkt(0,0), Winkel in Grad.
void setRotate(const QString Punkt, qreal Winkel, bool reset=true);
     //Drehung um Punkt, Winkel in Grad.
void setMirror(const QString Punkt1, const QString Punkt2, bool reset=true);
void setMirror(qreal x0, qreal y0, qreal x1, qreal y1, bool reset=true);
     //Spiegelung an der Geraden (Punkt1,Punkt2);
void setScale(qreal sx, qreal sy, bool reset=true);
void setShear(qreal sh, qreal sv, bool reset=true);
void setTranslate(qreal dx, qreal dy, bool reset=true);
     //Schiebung um (dy,dy)
void setIdentity();
     //Einheitsmatrix (reset)


/*! |Befehle: Turtlepolygon|**************************************************/
    //Befehle zum Abbilden des Turtlepolygons
    //mit 'drawMatrix'
    //Der erste Polygonpunkt hat den Index 0!

void setPolygon(int Index=0, int Anzahl=-1);
     //Turtlepolygons durch eine Abbildung mit drawMatrix ersetzen.
     //Der erste Polygonpunkt hat den Index 0!
     //Der letzte Polygonpunkt hat den Index -1.
     //
     //Index= 0, Anzahl=-1: Alle Punkte verwenden.
     //Index=-1, Anzahl=-1: Alle Punkte, Reihenfolge umgekehrt.
     //Index>=0, Anzahl>=0: Anzahl Punkte ab Index verwenden.
     //Index<-1, Anzahl>=0: Anzahl Punkte ab Index, Reihenfolge umgekehrt.


void addPolygon(const QString Name, int mode=0);
     //Turtlepolygon erweitern.
     //Das erste Polygon von "Name" mit drawMatrix abbilden
     //und zum Endpunkt des Turtlepolygons verschieben.
     //mode=0 : Punkte in gegebener Reihenfolge anhngen.
     //mode=-1: Punkte in umgekehrter Reihenfolge anhngen.

void setPolygon(const QString Name, int mode=0, qreal dt=0.1);
     //Turtlepolygon aus dem ersten Polygon von "Name" erzeugen.
     //"Name" wird zuerst mit drawMatrix abgebildet.
     //mode=0: Turtlepolygon durch "Name" ersetzen.
     //mode=-1: Turtlepolygon durch "Name" ersetzen. Reihenfolge umgekehrt.
     //mode=1: Turtlepolygon Duchschnitt "Name".
     //mode=2: Turtlepolygon Vereinigung "Name".
     //mode=3: Turtlepolygon geschlossen: Turtlepolygon ohne "Name".
     //Turtlepolygon offen: Turtlepolygon mit "Name" abschneiden.
     //mode = 4: "Name" liefert die Sttzpunkte eines quadratischen Bezier Splines.
     //epsilon<dt<1 Bestimmt die Punktedichte pro Spline-Segment.

void  msgPolygon(bool Spline=false);
      //Polygon als Funktion im Meldungsfenster anzeigen.
      //Kann ins direkt ins Script kopiert werden
      //Spline==true: Splinepolygon erzeugen


/*! |Befehle: Sonstiges|************************************************/
    // Verwaltung

bool exists(const QString Name);
     //Rckgabe true: Befehl 'Name' existiert.

void msgDraw(const QString Name="");
     //'Name': Alle Befehle der Befehlsliste anzeigen
     //'Name'=="": Infos zum Befehl 'Name'

QString drawInfo(const QString Name);
     //msgDraw() als String.

void clrDraw(const QString &Name);
     //Befehl 'Name' lschen.

void clrDraw();
     //Befehlsliste lschen

/*! End Javascript **************************************************/


/*! Begin class tScript Javascript **********************************/
/*! |t.Scripte| *****************************************************/
    //Scripte stellen Grafikfunktionen bereit


   /*! |Script Turtle|**************************/
    //Standardscript.
    //Siehe Menbefehl Scripte/Neues Script anhngen.

   ScriptBegin
   //Scriptanfang im Text
   var Grafik="Script Turtle";
   //Script "Script Turtle" aktivieren
   function init(){ }
   //Initialisierungen, obligatorisch
   function draw() {}
   //Zeichenbefehle,, obligatorisch
   ScriptEnd
   //Scriptende im Text
   ScriptEnd#Marke
   //Scriptende mit Textmarke. Mit der Marke
   //kann ein bestimmtes Script aus dem Text
   //aufgerufen werden.
   //
   //Beispiele:  ScriptEnd#2, ScriptEnd#Sinus

   /*! |Script Funktionen|***********************/
   //Script zum Zeichnen von Funktionsgrafen.
    var Grafik="Script Funktionen";
        //Script aktivieren

    var min= ;
        //Startwert (Option). Default linker Blattrand
    var max= ;
        //Endwert (Option). Default rechter Blattrand
        //min>max: Von max nach min zeichnen.
    var dt= ;
        //Schrittweite (Option).  Default 0.2

  void drawGraf(QString Name, qreal dx=0, qreal dy=0);
     //Funktionsgraf vom Typ f(x) zeichnen.
     //Name: Funktionsbezeichner.
     //(dx,dy): Verschiebung des Ursprungs
     //Beispiel: Funktion g(u){ return 2*u; }, Name="g"


  void drawGraf(QString Name1, QString Name2, qreal dx=0, qreal dy=0);
     //Parameterfunktionen vom Typ fx(u), fy(u) zeichnen
     //Name1 und Name2: Funktionsbezeichner.
     //(dx,dy): Verschiebung des Ursprungs


   /*! |Script Escher|***************************/
     //Scripte zum Verformen von Polygonobjekten
   var Grafik="Script Escher";
       //Script aktivieren

   function morphX(x,y) { return x; }
       //Wird von morphDraw() aufgerufen.
       //Liefert die neue x-Koordinate als
       //Funktion von x und y. Obligatorisch.

   function morphY(x,y) { return y; }
      //Wird von morphDraw() aufgerufen.
      //Liefert die neue y-Koordinate als
      //Funftion von x und y. Obligatorisch.

  void morphDraw(const QString Name, bool UseStyle=true);
       //Polygonobjekt 'Name' mit den Funktionen
       //function morphX(x,y){ ... return x; }
       //function morphY(x,y){ ... return y; }
       //morphen.

  void refineDraw(const QString Name, qreal maxL=0.2);
       //Polygonobjekt 'Name' durch Einfgen
       //von Zwischenpunkten verfeinern.

   /*! |Script Lindenmayer|**********************/
   //Scripte zum Erstellen von Lindenmayer-Grafiken.
   var Grafik="Script Lindenmayer";
       //Script aktivieren

   var Tiefe= ;
       //Rekursionstiefe
   var Alpha= ;
       //Winkel
   var Schritt=;
       //Schrittweite
   var Axiom= ;
       //Beispiel "X";

   var Regeln= ;
       //Beispiel "F() X()";
       //Mit function F(){return "FF";}
       //und function X(){return "F[+X]F[-X]+X";}

   void    makeLSystem();
          //L-System Definitionen aus dem Script lesen
          //und Modulstring erzeugen
  QString showLInfo();
          //Definitionen des L-Systems anzeigen
  void    drawLSystem();
          //Modulstring zeichnen
          //PolyMode 0 oder 1, siehe tTurtle
  QString showLModule();
          //Modulstring anzeigen



  /*! |Script Peano|*************************/
  var Grafik="Peano";
      //Script aktivieren

  var mode= ;
      //0 bis 4

  var Pen1= ;
      //Penfarbe

  var PenW= ;
      //Penwidth

  void A(int n, qreal l);
  void B(int n, qreal l);
  void C(int n, qreal l);
  void D(int n, qreal l);

  qreal getazul(int n,qreal l);
  //Kantenlaenge a zur Einheit l

  qreal getlzua(int a,qreal l);
  //Einheit l zur Kantenlaenge a


/*! |Math.Javascript|****************************/
  //Mathematische Funktionen

  real abs(x);
  //Returns the absolute value of x
  real acos(x);
  //Returns the arccosine of x, in radians
  real asin(x);
  //Returns the arcsine of x, in radians
  real atan(x);
  //Returns the arctangent of x as a numeric value between -PI/2 and PI/2 radians
  real atan2(y,x);
  //Returns the arctangent of the quotient of its arguments
  real ceil(x);
  //Returns x, rounded upwards to the nearest integer
  real cos(x);
  //Returns the cosine of x (x is in radians)
  real exp(x);
  //Returns the value of Ex
  real floor(x);
  //Returns x, rounded downwards to the nearest integer
  real log(x);
  //Returns the natural logarithm (base E) of x
  number max(x,y,z,...,n);
  //Returns the number with the highest value
  number min(x,y,z,...,n);
  //Returns the number with the lowest value
  const PI;
  //Returns Pi
  real pow(x,y);
  //Returns the value of x to the power of y
  real random();
  //Returns a random number between 0 and 1
  real round(x);
  //Rounds x to the nearest integer
  real sin(x);
  //Returns the sine of x (x is in radians)
  real sqrt(x);
  //Returns the square root of x
  real tan(x);
  //Returns the tangent of an angle

/*! |Number.Javascript|****************************/
  var x=45.1230;
  //Beispiel
  x.toFixed(2)
  //liefert 45.12
  x.toFixed(n)
  //Method formats a number using fixed-point notation.

  x.toPrecision(n)
  //The method returns a string representing the Number object to the specified precision.

  var a=123;
  //Beispiel
  a.toString()
  //"123", Zahlenbasis 10
  a.toString(2)
  //"1111011", Binrdarstellung
  a.toString(16)
  //"7b", Hexdarstellung

  Number.MAX_VALUE
  //Represents the maximum numeric value representable in JavaScript.

  Number.MIN_VALUE
  //Represents the smallest positive numeric value representable in JavaScript.

  Number.NaN
  //The property represents Not-A-Number. Equivalent of NaN.

  /*! |.Javascript| **************************************************/
    //Einige Befehle und Strukturen
  /*! |Kontrollstrukturen|*/
    function Name(){  }
    //Funktion ohne Parameter und Rckgabe.
    function Name(in){  return out;}
    //Funktion mit Parameter in und Rckgabe out.

    if (Bedingung) { Block1 } else { Block1 }
    //if Statement.
    //Bedingungen: gleich == , ungleich != , >=, <=, <, >

    switch(n){case 1: block1 break; case 2: break; usw. default: block}
    //Fallentscheidung. break; nicht vergessen!

  /*! |Schleifen|*/
    for(i=0; i<100; i++){ }
    //Wiederholung i von 0 bis 99
    while (Bedingung) { }
    //Wiederholungen 0 bis unendlich
    do { } while (Bedingung);
    //Wiederholungen 1 bis unendlich

/*! End ****/
#endif
